/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin.AdAstraMixin;

import com.hoshino.cti.util.PlanetUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.ad_astra.client.screen.util.CustomButton;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import earth.terrarium.ad_astra.common.data.Planet;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(remap=false, value={CustomButton.class})
public class CustomButtonMixin {
    @Final
    @Shadow
    private PlanetSelectionScreen.TooltipType tooltip;
    @Final
    @Shadow
    private Planet planetInfo;
    @Final
    @Shadow
    private Component label;

    @Overwrite
    private void renderTooltips(PoseStack poseStack, int mouseX, int mouseY, Minecraft minecraft) {
        String var10001;
        Screen screen = minecraft.f_91080_;
        LinkedList<Component> textEntries = new LinkedList<Component>();
        switch (this.tooltip) {
            default: {
                break;
            }
            case GALAXY: {
                var10001 = PlanetSelectionScreen.CATEGORY_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7b" + this.label.getString())));
                var10001 = PlanetSelectionScreen.TYPE_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a75" + PlanetSelectionScreen.GALAXY_TEXT.getString())));
                break;
            }
            case SOLAR_SYSTEM: {
                var10001 = PlanetSelectionScreen.CATEGORY_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7b" + this.label.getString())));
                var10001 = PlanetSelectionScreen.TYPE_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a73" + PlanetSelectionScreen.SOLAR_SYSTEM_TEXT.getString())));
                break;
            }
            case CATEGORY: {
                var10001 = PlanetSelectionScreen.CATEGORY_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7a" + this.label.getString())));
                var10001 = PlanetSelectionScreen.PROVIDED_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7b" + Component.m_237115_((String)("item.ad_astra.tier_" + this.planetInfo.rocketTier() + "_rocket")).getString())));
                break;
            }
            case PLANET: {
                var10001 = PlanetSelectionScreen.TYPE_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a73" + (this.planetInfo.parentWorld() == null ? PlanetSelectionScreen.PLANET_TEXT.getString() : PlanetSelectionScreen.MOON_TEXT.getString()))));
                var10001 = PlanetSelectionScreen.GRAVITY_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a73" + this.planetInfo.gravity() + " m/s")));
                var10001 = PlanetSelectionScreen.OXYGEN_TEXT.getString();
                textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7" + (this.planetInfo.hasOxygen() ? "a" + PlanetSelectionScreen.OXYGEN_TRUE_TEXT.getString() : "c" + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString()))));
                String temperatureColour = "\u00a7a";
                if (this.planetInfo.temperature() > 50.0f) {
                    temperatureColour = "\u00a76";
                } else if (this.planetInfo.temperature() < -20.0f) {
                    temperatureColour = "\u00a71";
                }
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": " + temperatureColour + " " + this.planetInfo.temperature() + " \u00b0C")));
                textEntries.add(Component.m_130674_((String)("\u00a7b\u538b\u5f3a\u5371\u5bb3: " + PlanetUtil.getPressureDisplay(this.planetInfo))));
                textEntries.add(Component.m_130674_((String)("\u00a7b\u971c\u51bb\u5371\u5bb3: " + PlanetUtil.getFreezeDisplay(this.planetInfo))));
                textEntries.add(Component.m_130674_((String)("\u00a7b\u707c\u70ed\u5371\u5bb3: " + PlanetUtil.getScorchDisplay(this.planetInfo))));
                textEntries.add(Component.m_130674_((String)("\u00a7b\u7535\u79bb\u5371\u5bb3: " + PlanetUtil.getIonizeDisplay(this.planetInfo))));
                break;
            }
            case SPACE_STATION: {
                PlanetSelectionScreen currentScreen = (PlanetSelectionScreen)minecraft.f_91080_;
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.ITEM_REQUIREMENT_TEXT.getString())));
                currentScreen.ingredients.forEach(ingredient -> {
                    boolean isEnough = ((ItemStack)ingredient.getFirst()).m_41613_() >= (Integer)ingredient.getSecond();
                    textEntries.add(Component.m_130674_((String)("\u00a7" + (isEnough ? "a" : "c") + ((ItemStack)ingredient.getFirst()).m_41613_() + "/" + ingredient.getSecond() + " \u00a73" + ((ItemStack)ingredient.getFirst()).m_41786_().getString())));
                });
                textEntries.add(Component.m_130674_((String)"\u00a7c----------------"));
            }
        }
        if (this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.ORBIT) || this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.SPACE_STATION)) {
            var10001 = PlanetSelectionScreen.TYPE_TEXT.getString();
            textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a73" + PlanetSelectionScreen.ORBIT_TEXT.getString())));
            var10001 = PlanetSelectionScreen.GRAVITY_TEXT.getString();
            textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a73" + PlanetSelectionScreen.NO_GRAVITY_TEXT.getString())));
            var10001 = PlanetSelectionScreen.OXYGEN_TEXT.getString();
            textEntries.add(Component.m_130674_((String)("\u00a79" + var10001 + ": \u00a7c " + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString())));
            textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a71 -270.0 \u00b0C")));
        }
        screen.m_96597_(poseStack, textEntries, mouseX, mouseY);
    }
}

